(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15194,        385]
NotebookOptionsPosition[     14711,        370]
NotebookOutlinePosition[     15046,        385]
CellTagsIndexPosition[     15003,        382]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"files", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<pars_\>\"", "<>", 
       RowBox[{"ToString", "[", "n", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"{", 
         RowBox[{
         "228", ",", "234", ",", "240", ",", "246", ",", "258", ",", "270"}], 
         "}"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resmsd", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resvacf", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resfit", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DQ", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"tardirs", "=", 
       RowBox[{"FileNames", "@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
          RowBox[{"FileBaseName", "@", "file"}], "<>", "\"\</rng*\>\""}], 
         ")"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"vacf", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"msd", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"cfg", "=", 
       RowBox[{"Mean", "@", 
        RowBox[{"First", "@", 
         RowBox[{"Last", "@", 
          RowBox[{"Reap", "@", 
           RowBox[{"Do", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"Sow", "@", 
               RowBox[{"Flatten", "@", 
                RowBox[{"First", "@", 
                 RowBox[{"Last", "@", 
                  RowBox[{"Reap", "[", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"config", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{"tardir", "<>", "\"\</config.json\>\""}], "]"}]}],
                     ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<SUBSTRATE_ADHESION_POLARIZABILITY\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<STIFFNESS_MEMBRANE\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";"}], "\[IndentingNewLine]", "]"}]}]}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"vacf", "=", 
               RowBox[{"Join", "[", 
                RowBox[{"vacf", ",", 
                 RowBox[{"Import", "[", 
                  RowBox[{
                   RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                   "\"\</Simple/VACF\>\""}], "]"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"msd", "=", 
               RowBox[{"Join", "[", 
                RowBox[{"msd", ",", 
                 RowBox[{"Import", "[", 
                  RowBox[{
                   RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                   "\"\</Simple/MSD\>\""}], "]"}]}], "]"}]}], ";"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{"tardir", ",", "tardirs"}], "}"}]}], "]"}]}]}]}]}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"DQ", ",", 
        RowBox[{
         RowBox[{"cfg", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "/", 
         RowBox[{"cfg", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "No", " ", "Data", " ", "is", " ", "excluded", " ", "from", " ", "the",
         " ", 
        RowBox[{"MSD", "!"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"grpmsd", "=", 
       RowBox[{"GroupBy", "[", 
        RowBox[{"msd", ",", "First"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"meanmsd", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"\"\<DeltaTime\>\"", "/.", "val"}], "//", "Mean"}], ",", 
           RowBox[{
            RowBox[{"\"\<Mean\>\"", "/.", "val"}], "//", "Mean"}], ",", 
           RowBox[{
            RowBox[{"\"\<Mean\>\"", "/.", "val"}], "//", 
            "StandardDeviation"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"val", ",", "grpmsd"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"resmsd", ",", "meanmsd"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"msdfit", "=", 
       RowBox[{"NonlinearModelFit", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"meanmsd", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"-", "1"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"A", "^", "2"}], "*", 
            RowBox[{"tau", "^", "2"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{"-", "t"}], "/", "tau"}], "]"}], "+", 
              RowBox[{"t", "/", "tau"}], "-", "1"}], ")"}]}], ",", 
           RowBox[{"tau", ">", "0.0001"}], ",", 
           RowBox[{"A", ">", "0"}]}], "}"}], "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"A", ",", "10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"tau", ",", "10000"}], "}"}]}], "}"}], 
         "\[IndentingNewLine]", ",", "t", ",", 
         RowBox[{"Weights", "\[Rule]", 
          RowBox[{"1", "/", 
           RowBox[{
            RowBox[{"meanmsd", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"2", ";;", 
                RowBox[{"-", "1"}]}], ",", "3"}], "]"}], "]"}], "^", 
            "2"}]}]}], ",", 
         RowBox[{"Method", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"NMinimize", ",", 
            RowBox[{"Method", "\[Rule]", "\"\<NelderMead\>\""}]}], "}"}]}], 
         ",", 
         RowBox[{"ConfidenceLevel", "\[Rule]", "0.999"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"resfit", ",", "msdfit"}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Velocities", " ", "that", " ", "are", " ", "too", " ", "small", " ", 
        RowBox[{"(", "artifacts", ")"}], " ", "are", " ", "excluded", " ", 
        "from", " ", "the", " ", 
        RowBox[{"VACF", "!"}], " ", "See", " ", "Implementation", " ", "of", 
        " ", "the", " ", "Processing", " ", 
        RowBox[{"Code", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"grpvacf", "=", 
       RowBox[{"GroupBy", "[", 
        RowBox[{"vacf", ",", "First"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"meanvacf", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"\"\<DeltaTime\>\"", "/.", "val"}], "//", "Mean"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"\"\<Mean\>\"", "*", "\"\<Count\>\""}], "/.", "val"}], 
              "//", "Total"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\"\<Count\>\"", "/.", "val"}], "//", "Total"}], 
             ")"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"val", ",", "grpvacf"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"resvacf", ",", "meanvacf"}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"file", ",", "files"}], "}"}]}], "]"}], ",", "file"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.7410776024288073`*^9, 3.741077642619318*^9}, {
   3.741077678273327*^9, 3.741077848187665*^9}, {3.741077928760242*^9, 
   3.741077957065653*^9}, {3.741333723574176*^9, 3.74133372542239*^9}, {
   3.7415152418403053`*^9, 3.7415152470988817`*^9}, {3.741518024014843*^9, 
   3.741518051186194*^9}, {3.742566355719413*^9, 3.7425663559800167`*^9}, {
   3.742632081684648*^9, 3.7426320840371733`*^9}, 3.742632137941222*^9, 
   3.742632179884989*^9, {3.742632245588373*^9, 3.7426323834313107`*^9}, {
   3.742632461171932*^9, 3.742632465803966*^9}, {3.742642056488977*^9, 
   3.742642156291671*^9}, {3.742642391004571*^9, 3.742642401730844*^9}, {
   3.742643110904523*^9, 3.742643111088286*^9}, {3.7765013770071993`*^9, 
   3.7765013908301363`*^9}, {3.776501461946701*^9, 3.776501467815624*^9}, {
   3.776501938445888*^9, 3.7765020089927683`*^9}, 3.7765021094747353`*^9, {
   3.776502139748929*^9, 3.7765021482806597`*^9}, {3.776503688156118*^9, 
   3.7765036994831543`*^9}, {3.776503804860705*^9, 3.776503812250401*^9}, {
   3.776503853381896*^9, 3.77650385416434*^9}, {3.776503996872122*^9, 
   3.776503999201961*^9}, 3.776504232393217*^9, {3.7765042771462307`*^9, 
   3.7765043259415627`*^9}, {3.776510840652669*^9, 3.776510843330729*^9}, {
   3.7765166565762253`*^9, 3.776516657301148*^9}, {3.7765170513323307`*^9, 
   3.776517051599539*^9}, {3.7765173675942707`*^9, 3.776517367817177*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"f1cc911e-50a4-406e-994b-1e7bf09337d7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/MSD_470.dat\>\"", ",", 
      RowBox[{"resmsd", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/MSD_535.dat\>\"", ",", 
      RowBox[{"resmsd", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/MSD_600.dat\>\"", ",", 
      RowBox[{"resmsd", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/MSD_665.dat\>\"", ",", 
      RowBox[{"resmsd", "[", 
       RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/MSD_795.dat\>\"", ",", 
      RowBox[{"resmsd", "[", 
       RowBox[{"[", "5", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/MSD_925.dat\>\"", ",", 
      RowBox[{"resmsd", "[", 
       RowBox[{"[", "6", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/VACF_470.dat\>\"", ",", 
      RowBox[{"resvacf", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/VACF_535.dat\>\"", ",", 
      RowBox[{"resvacf", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/VACF_600.dat\>\"", ",", 
      RowBox[{"resvacf", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/VACF_665.dat\>\"", ",", 
      RowBox[{"resvacf", "[", 
       RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/VACF_795.dat\>\"", ",", 
      RowBox[{"resvacf", "[", 
       RowBox[{"[", "5", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Downloads/VACF_925.dat\>\"", ",", 
      RowBox[{"resvacf", "[", 
       RowBox[{"[", "6", "]"}], "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741333735840199*^9, 3.741333800831539*^9}, {
  3.741469082422647*^9, 3.741469106853611*^9}, {3.741518579302147*^9, 
  3.741518597462826*^9}, {3.776502163388825*^9, 3.77650217115792*^9}, {
  3.776511799961068*^9, 3.776511800404562*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"3cfe6efb-e0e4-454e-81c1-6bc5311d1a86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "fits"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<~/Downloads/MSDfits.dat\>\"", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A", ",", "tau"}], "}"}], "/.", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"resfit", "[", 
          RowBox[{"[", "k", "]"}], "]"}], "[", "\"\<BestFitParameters\>\"", 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "6"}], "}"}]}], "]"}]}]}], "]"}], ";"}]}]], "Input",\

 CellChangeTimes->{{3.7413343378152437`*^9, 3.74133438747904*^9}, {
   3.741334505769808*^9, 3.7413345286915617`*^9}, {3.741469132909102*^9, 
   3.7414691333163757`*^9}, 3.741518632260186*^9, {3.776502193454728*^9, 
   3.776502200814741*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"a94a0649-06b5-4cd2-a16f-176635d9f149"]
},
WindowSize->{808, 755},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 10261, 241, 1102, "Input",ExpressionUUID->"f1cc911e-50a4-406e-994b-1e7bf09337d7"],
Cell[10822, 263, 2971, 80, 304, "Input",ExpressionUUID->"3cfe6efb-e0e4-454e-81c1-6bc5311d1a86"],
Cell[13796, 345, 911, 23, 73, "Input",ExpressionUUID->"a94a0649-06b5-4cd2-a16f-176635d9f149"]
}
]
*)

